/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class HuitReines
extends Applet
implements Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    private Panel ctrl_ = null;
    private Panel opts_ = null;
    private Button go_ = null;
    private Button step_ = null;
    private Button stop_ = null;
    private Scrollbar scroll_ = null;
    private Label speed_ = null;
    private Situation s_ = null;
    private Checkbox r90_ = null;
    private Checkbox r_90_ = null;
    private Checkbox r180_ = null;
    private Checkbox mvert_ = null;
    private Checkbox r90v_ = null;
    private Checkbox r_90v_ = null;
    private Checkbox r180v_ = null;
    private static final int hpad = 10;
    private static final int vpad = 10;
    private Thread queens_ = null;
    private boolean destroyed_ = false;
    private static boolean application_ = false;

    public static void main(String[] stringArray) {
        application_ = true;
        TopWindow topWindow = new TopWindow("Les 8 reines");
        HuitReines huitReines = new HuitReines();
        topWindow.add(huitReines);
        topWindow.setVisible(true);
        huitReines.init();
        huitReines.start();
    }

    public void init() {
        this.destroyed_ = false;
        if (this.queens_ == null) {
            this.queens_ = new Thread(this);
        }
        this.queens_.start();
    }

    public void destroy() {
        this.destroyed_ = true;
        this.queens_.interrupt();
    }

    public void start() {
    }

    public void stop() {
    }

    public void run() {
        while (!this.destroyed_) {
            this.s_.placer();
            this.s_.reset();
        }
    }

    private void setupGUI() {
        this.queens_ = null;
        this.setLayout(null);
        this.opts_ = new Panel(new GridLayout(0, 1, 5, 15));
        this.opts_.add(new Label("Optimisations"));
        this.r90_ = new Checkbox("R 90\u00b0", true);
        this.r90_.addItemListener(this);
        this.opts_.add(this.r90_);
        this.r_90_ = new Checkbox("R -90\u00b0", true);
        this.r_90_.addItemListener(this);
        this.opts_.add(this.r_90_);
        this.r180_ = new Checkbox("R 180\u00b0", true);
        this.r180_.addItemListener(this);
        this.opts_.add(this.r180_);
        this.mvert_ = new Checkbox("M Vert.", true);
        this.mvert_.addItemListener(this);
        this.opts_.add(this.mvert_);
        this.r90v_ = new Checkbox("R 90\u00b0 + MV", true);
        this.r90v_.addItemListener(this);
        this.opts_.add(this.r90v_);
        this.r_90v_ = new Checkbox("R -90\u00b0 + MV", true);
        this.r_90v_.addItemListener(this);
        this.opts_.add(this.r_90v_);
        this.r180v_ = new Checkbox("R 180\u00b0 + MV", true);
        this.r180v_.addItemListener(this);
        this.opts_.add(this.r180v_);
        this.add(this.opts_);
        this.s_ = new Situation();
        this.add(this.s_);
        this.ctrl_ = new Panel();
        this.go_ = new Button("Marche");
        this.go_.setActionCommand("Go");
        this.go_.addActionListener(this);
        this.ctrl_.add(this.go_);
        this.step_ = new Button("Pas \u00e0 pas");
        this.step_.addActionListener(this);
        this.step_.setActionCommand("Step");
        this.ctrl_.add(this.step_);
        this.stop_ = new Button("Arr\u00eat");
        this.stop_.addActionListener(this);
        this.stop_.setActionCommand("Stop");
        this.ctrl_.add(this.stop_);
        Button button = new Button("R\u00e0Z");
        button.addActionListener(this);
        button.setActionCommand("Reset");
        this.ctrl_.add(button);
        if (application_) {
            Button button2 = new Button("Quitter");
            button2.setActionCommand("Quit");
            button2.addActionListener(this);
            this.ctrl_.add(button2);
        }
        this.add(this.ctrl_);
        this.scroll_ = new Scrollbar(0, 50, 1, 1, 101);
        this.scroll_.addAdjustmentListener(this);
        this.scroll_.setValue(50);
        this.add(this.scroll_);
        this.speed_ = new Label("Vitesse : 50%  ");
        this.add(this.speed_);
        this.setBackground(Color.white);
    }

    public HuitReines() {
        this.setupGUI();
        this.setVisible(true);
    }

    public void doLayout() {
        int n;
        Insets insets = this.getInsets();
        Dimension dimension = this.ctrl_.getPreferredSize();
        Dimension dimension2 = this.s_.getSize();
        Dimension dimension3 = this.scroll_.getPreferredSize();
        Dimension dimension4 = this.speed_.getPreferredSize();
        Dimension dimension5 = this.opts_.getPreferredSize();
        int n2 = dimension.width;
        int n3 = dimension2.width + dimension5.width + 10;
        if (n2 < n3) {
            n2 = n3;
        }
        if ((n = dimension2.height) < dimension5.height) {
            n = dimension5.height;
        }
        int n4 = (n2 - n3) / 2;
        int n5 = (n2 - dimension.width) / 2;
        this.setSize(insets.left + 20 + n2 + insets.right, insets.top + 30 + n + dimension.height + dimension3.height + insets.bottom);
        this.opts_.setBounds(insets.left + 10, insets.top + 10, dimension5.width, dimension5.height);
        this.s_.setLocation(insets.left + 20 + n4 + dimension5.width, insets.top + 10);
        this.ctrl_.setBounds(insets.left + n5 + 10, insets.top + 10 + n, dimension.width, dimension.height);
        this.scroll_.setBounds(insets.left + 10, insets.top + 10 + n + dimension.height, n2 - 10 - dimension4.width, dimension3.height);
        this.speed_.setBounds(insets.left + n2 - dimension4.width + 10, insets.top + 10 + n + dimension.height, dimension4.width, dimension4.height);
    }

    public Dimension getPreferredSize() {
        this.validate();
        return this.getSize();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Go")) {
            this.s_.go();
        } else if (actionEvent.getActionCommand().equals("Step")) {
            this.s_.step();
        } else if (actionEvent.getActionCommand().equals("Stop")) {
            this.s_.stop();
        } else if (actionEvent.getActionCommand().equals("Reset")) {
            this.s_.reset();
        } else if (actionEvent.getActionCommand().equals("Quit")) {
            System.exit(0);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getValue();
        if (n > 100) {
            n = 100;
        }
        this.s_.setSpeed(100 - n);
        this.speed_.setText("Vitesse : " + n + "%");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        boolean bl = checkbox.getState();
        int n = 0;
        if (checkbox == this.r90_) {
            n = 1;
        } else if (checkbox == this.r_90_) {
            n = 2;
        } else if (checkbox == this.r180_) {
            n = 4;
        } else if (checkbox == this.mvert_) {
            n = 8;
        } else if (checkbox == this.r90v_) {
            n = 16;
        } else if (checkbox == this.r_90v_) {
            n = 64;
        } else if (checkbox == this.r180v_) {
            n = 32;
        }
        if (bl) {
            this.s_.ajouterOptimisations(n);
        } else {
            this.s_.supprimerOptimisations(n);
        }
    }
}

